/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.fcs.impl.disc.bcast;

import com.ibm.hwmca.fw.fcs.FcsEvent;
import com.ibm.hwmca.fw.fcs.FcsEventListener;
import com.ibm.hwmca.fw.fcs.FcsException;
import com.ibm.hwmca.fw.fcs.FcsServer;
import com.ibm.hwmca.fw.fcs.MachineId;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryCenter;
import com.ibm.hwmca.fw.fcs.impl.disc.DiscoveryPlugin;
import com.ibm.hwmca.fw.fcs.impl.disc.bcast.DatagramPortOwner;
import com.ibm.hwmca.fw.fcs.impl.stream.FcsControlClient;
import com.ibm.hwmca.fw.fcs.impl.udp.FcsDatagram;
import com.ibm.hwmca.fw.util.NamedTimer;
import com.ibm.hwmca.fw.util.Trace;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TimerTask;

public class DatagramPlugin
implements Runnable,
DiscoveryPlugin,
FcsEventListener {
    private static final String TRACE_MASKD = "XFCSDGLD";
    private static final String TRACE_MASKF = "XFCSDGLF";
    private static final String TRACE_MASKT = "XFCSDGLT";
    private DatagramPortOwner dpo;
    private MachineId machineId;
    private boolean _doWork;
    private Object doWorkLock;
    NamedTimer datagramTimer;

    public DatagramPlugin() {
        Trace.trace(TRACE_MASKF, "-> DatagramPlugin()");
        this._doWork = true;
        this.doWorkLock = new Object();
        this.machineId = FcsServer.getFcsServer().getLocalMachineId();
        this.datagramTimer = new NamedTimer(true, "Datagram Sending Timer");
        this.datagramTimer.schedule((TimerTask)new DatagramTask(), 1000L, (long)(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000));
        Trace.trace(TRACE_MASKF, "<- DatagramPlugin()");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        boolean doWork = true;
        this.dpo = DatagramPortOwner.getDatagramPortOwner();
        FcsServer.getFcsServer().addFcsEventListener(this);
        while (doWork) {
            DatagramPacket inPacket = this.dpo.receive();
            try {
                if (inPacket != null) {
                    FcsDatagram datagram = new FcsDatagram(inPacket);
                    if (datagram.isQuery() && this.needsResponse(datagram)) {
                        FcsDatagram response = new FcsDatagram(this.machineId, 2);
                        DatagramPacket outPacket = response.asPacket();
                        outPacket.setAddress(inPacket.getAddress());
                        outPacket.setPort(9900);
                        this.dpo.send(outPacket);
                        Trace.trace(TRACE_MASKF, "got a query");
                        DiscoveryCenter.getDiscoveryCenter().foundAddress(inPacket.getAddress(), this);
                    } else if (datagram.isResponse() && this.needsResponse(datagram)) {
                        MachineId mid = FcsServer.getFcsServer().getMachineId(inPacket.getAddress());
                        if (mid == null) {
                            Trace.trace(TRACE_MASKF, "got a response, giving to discovery center");
                            DiscoveryCenter.getDiscoveryCenter().foundAddress(inPacket.getAddress(), this);
                        } else {
                            int counter;
                            Trace.trace(TRACE_MASKF, "just got a response");
                            String address = inPacket.getAddress().getHostAddress();
                            Object o = map.get(address);
                            if (o == null) {
                                o = new Integer(-1);
                            }
                            if ((counter = ((Integer)o).intValue()) == 3) {
                                counter = -1;
                            }
                            map.put(address, new Integer(++counter));
                        }
                    } else if (datagram.isUpdate() && this.needsResponse(datagram)) {
                        if (FcsServer.getFcsServer().getConfigManager().getMachineListPingTime() > 600) {
                            Trace.trace(TRACE_MASKF, "got an update, forcing resync");
                            this.startQueryClient(inPacket.getAddress());
                        } else {
                            Trace.trace(TRACE_MASKF, "just got an update");
                        }
                    }
                } else if (this.dpo.socketBuildError()) {
                    Trace.trace(TRACE_MASKF, "error building sockets.  Stopping datagram plugin");
                    this.stopWork();
                }
            }
            catch (FcsException fcse) {
                // empty catch block
            }
            Object object = this.doWorkLock;
            synchronized (object) {
                doWork = this._doWork;
            }
        }
        map.clear();
        map = null;
    }

    private void notifyKnownMachines() {
        MachineId localMachine = FcsServer.getFcsServer().getLocalMachineId();
        Set otherMachines = FcsServer.getFcsServer().getMachineList();
        Iterator i = otherMachines.iterator();
        while (i.hasNext()) {
            MachineId machineId = (MachineId)i.next();
            FcsDatagram datagram = new FcsDatagram(localMachine, 3);
            DatagramPacket packet = datagram.asPacket();
            packet.setAddress(machineId.getNicAddresses()[0]);
            packet.setPort(9900);
            DatagramPortOwner.getDatagramPortOwner().send(packet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fcsStateChanged(FcsEvent event) {
        if (event.getEventType() == 3 && event.getEventDetails() == 150) {
            this.stopWork();
            this.datagramTimer.cancel();
            DatagramPortOwner.getDatagramPortOwner().closeSocket();
        } else if (event.getEventType() == 3 && event.getEventDetails() == 151) {
            Object object = this.doWorkLock;
            synchronized (object) {
                this._doWork = true;
            }
            DatagramPortOwner.getDatagramPortOwner().restart();
            Thread t = new Thread((Runnable)this, "FCS Datagram Plugin discovery thread");
            t.start();
            this.datagramTimer.schedule((TimerTask)new DatagramTask(), 1000L, (long)(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000));
        } else if (event.getEventType() == 1 && event.getEventDetails() == 54 && event.getOldMachineId() == this.machineId) {
            this.machineId = event.getMachineId();
            DatagramPortOwner.getDatagramPortOwner().networkSettingsChanged();
            this.datagramTimer.schedule((TimerTask)new DatagramTask(), 1000L, (long)(FcsServer.getFcsServer().getConfigManager().getMachineSearchTime() * 1000));
        } else if (event.getEventType() == 2 && event.getMachineId().equals(FcsServer.getFcsServer().getLocalMachineId())) {
            this.notifyKnownMachines();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopWork() {
        Object object = this.doWorkLock;
        synchronized (object) {
            this._doWork = false;
        }
    }

    private boolean needsResponse(FcsDatagram packet) {
        return packet.getMachineId().getGroup().equals(this.machineId.getGroup());
    }

    private void startQueryClient(InetAddress iaddr) {
        if (iaddr != null) {
            FcsControlClient fcc = new FcsControlClient(iaddr, "FcsControlCommandDataExchange");
            Thread t = new Thread((Runnable)fcc, "FCS Control Client to " + iaddr.toString());
            t.start();
        }
    }

    class DatagramTask
    extends TimerTask {
        DatagramTask() {
        }

        public void run() {
            Trace.trace(DatagramPlugin.TRACE_MASKF, " DatagramTask pops, sending packet.");
            try {
                if (FcsServer.getFcsServer().getConfigManager().isUseMulticast()) {
                    this.findMulticast();
                } else {
                    this.findSubnet();
                }
            }
            catch (FcsException fcse) {
                fcse.printStackTrace();
            }
        }

        public boolean cancel() {
            Trace.trace(DatagramPlugin.TRACE_MASKF, " DatagramTask canceled.");
            return super.cancel();
        }

        public void schedule(int delay) {
            Trace.trace(DatagramPlugin.TRACE_MASKF, " DatagramTask scheduling timer pop " + delay + "ms in future.");
            DatagramPlugin.this.datagramTimer.schedule((TimerTask)this, delay);
        }

        public void findSubnet() throws FcsException {
            try {
                InetAddress iaddr = InetAddress.getByName("255.255.255.255");
                this.sendPacket(iaddr);
            }
            catch (UnknownHostException uhe) {
                throw new FcsException(uhe);
            }
        }

        public void findMulticast() throws FcsException {
            try {
                InetAddress group = InetAddress.getByName("225.4.5.6");
                this.sendPacket(group);
            }
            catch (UnknownHostException uhe) {
                throw new FcsException(uhe);
            }
        }

        private void sendPacket(InetAddress iaddr) {
            FcsDatagram query = new FcsDatagram(FcsServer.getFcsServer().getLocalMachineId(), 1);
            DatagramPacket packet = query.asPacket();
            packet.setAddress(iaddr);
            packet.setPort(9900);
            DatagramPortOwner.getDatagramPortOwner().send(packet);
        }
    }
}

